/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.enderchestmod.items;

import io.redspace.enderchestmod.blocks.AbstractEnderChestBlockEntity;
import io.redspace.enderchestmod.blocks.copper_ender_chest.CopperEnderChestEntity;
import io.redspace.enderchestmod.blocks.diamond_ender_chest.DiamondEnderChestEntity;
import io.redspace.enderchestmod.blocks.emerald_ender_chest.EmeraldEnderChestEntity;
import io.redspace.enderchestmod.blocks.gold_ender_chest.GoldEnderChestEntity;
import io.redspace.enderchestmod.blocks.iron_ender_chest.IronEnderChestEntity;
import io.redspace.enderchestmod.blocks.lapis_ender_chest.LapisEnderChestEntity;
import io.redspace.enderchestmod.blocks.netherite_ender_chest.NetheriteEnderChestEntity;
import io.redspace.enderchestmod.blocks.redstone_ender_chest.RedstoneEnderChestEntity;
import io.redspace.enderchestmod.client.TieredEnderChestItemStackRenderer;
import io.redspace.enderchestmod.items.ItemPropertyGetter;
import io.redspace.enderchestmod.registries.BlockRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EnderChestBlockItem
extends BlockItem {
    private final Block block;
    final List<Component> description;

    public EnderChestBlockItem(Block pBlock, boolean fireImmune, String ... description) {
        super(pBlock, ItemPropertyGetter.get(fireImmune));
        this.block = pBlock;
        this.description = new ArrayList<Component>();
        for (String str : description) {
            this.description.add((Component)Component.m_237115_((String)str).m_130940_(ChatFormatting.GRAY));
        }
    }

    public void initializeClient(@NotNull Consumer<IClientItemExtensions> consumer) {
        super.initializeClient(consumer);
        consumer.accept(new IClientItemExtensions(){

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                return new TieredEnderChestItemStackRenderer<AbstractEnderChestBlockEntity>(Minecraft.m_91087_().m_167982_(), Minecraft.m_91087_().m_167973_(), EnderChestBlockItem.this::getEntityToRender);
            }
        });
    }

    protected AbstractEnderChestBlockEntity getEntityToRender() {
        return switch (this.block.m_7705_()) {
            case "block.iron_ender_chests.diamond_ender_chest" -> new DiamondEnderChestEntity(BlockPos.f_121853_, ((Block)BlockRegistry.DIAMOND_ENDER_CHEST.get()).m_49966_());
            case "block.iron_ender_chests.netherite_ender_chest" -> new NetheriteEnderChestEntity(BlockPos.f_121853_, ((Block)BlockRegistry.NETHERITE_ENDER_CHEST.get()).m_49966_());
            case "block.iron_ender_chests.copper_ender_chest" -> new CopperEnderChestEntity(BlockPos.f_121853_, ((Block)BlockRegistry.COPPER_ENDER_CHEST.get()).m_49966_());
            case "block.iron_ender_chests.gold_ender_chest" -> new GoldEnderChestEntity(BlockPos.f_121853_, ((Block)BlockRegistry.GOLD_ENDER_CHEST.get()).m_49966_());
            case "block.iron_ender_chests.lapis_ender_chest" -> new LapisEnderChestEntity(BlockPos.f_121853_, ((Block)BlockRegistry.LAPIS_ENDER_CHEST.get()).m_49966_());
            case "block.iron_ender_chests.redstone_ender_chest" -> new RedstoneEnderChestEntity(BlockPos.f_121853_, ((Block)BlockRegistry.REDSTONE_ENDER_CHEST.get()).m_49966_());
            case "block.iron_ender_chests.emerald_ender_chest" -> new EmeraldEnderChestEntity(BlockPos.f_121853_, ((Block)BlockRegistry.EMERALD_ENDER_CHEST.get()).m_49966_());
            default -> new IronEnderChestEntity(BlockPos.f_121853_, ((Block)BlockRegistry.IRON_ENDER_CHEST.get()).m_49966_());
        };
    }

    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltip, TooltipFlag pFlag) {
        super.m_7373_(pStack, pLevel, pTooltip, pFlag);
        pTooltip.addAll(this.description);
    }
}

